#ifndef _CONSOLEPROCS_CPP
#define _CONSOLEPROCS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>

#include "NSWFL.H"
#include "Entry.H"
#include "Init.H"
#include "WinService.H"
#include "Routines.H"
#include "Console.H"
#include "ConsoleProcs.H"

#include "../SockServer/SockServer.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool DumpSQLStatsToConsole(HSTMT StatementHandle)
{
/*
	char StatusText[1024];
    SQLSMALLINT outColumnCount = 0;
    SQLINTEGER outRowCount = 0;

    if(SQLNumResultCols(StatementHandle, &outColumnCount) != SQL_SUCCESS)
    {
        WriteCon("SQLNumResultCols: Error.\n");
        return 0;
    }

    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
        WriteCon("SQLRowCount: Error.\n");
        return 0;
    }

    sprintf(StatusText, "%d rows affected.\n", outRowCount, outColumnCount);
    WriteCon(StatusText);
*/
    return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool DumpSQLResultsToConsole(HSTMT StatementHandle)
{
/*
	//---------------( Get Columb Data )---
    char StatusText[1024];

	int ColumbLoop = 0;
    SQLSMALLINT outColumnCount = 0;
    SQLINTEGER outRowCount = 0;

    SQLSMALLINT inColumnNameLen = 256;

	SQLUINTEGER outColumnSizePtr = 0;

    SQLSMALLINT outColumnNameLen = 0;
    SQLSMALLINT *outDataType = 0;
    SQLSMALLINT outDecimalDigitsPtr = 0;
    SQLSMALLINT outNullablePtr = 0;

    SQLCHAR outColumnName[256];

    SQLRETURN SQLResult = 0;


    if(SQLNumResultCols(StatementHandle, &outColumnCount) != SQL_SUCCESS)
    {
        WriteCon("SQLNumResultCols: Error.\n");

        return 0;
    }

    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
        WriteCon("SQLRowCount: Error.\n");
        return 0;
    }

    if(outRowCount == 0)
    {
        WriteCon("0 rows affected.\n");
        return 0;
    }

    outDataType = (SQLSMALLINT *) calloc( sizeof(SQLSMALLINT), outColumnCount);

    do{
        SQLResult = SQLDescribeCol(StatementHandle, ColumbLoop + 1, outColumnName, inColumnNameLen,
            &outColumnNameLen, &outDataType[ColumbLoop], &outColumnSizePtr, &outDecimalDigitsPtr, &outNullablePtr
        );

        if(SQLResult == SQL_SUCCESS)
        {
            WriteCon((char *)outColumnName);
            WriteCon("\t");
        }

        ColumbLoop++;
    }
    while(SQLResult == SQL_SUCCESS);


	while(DBFetch(StatementHandle))
    {
        SQLINTEGER DataLength = 0;

        ColumbLoop = 0;
        while(ColumbLoop < outColumnCount)
        {
            SQLSMALLINT DataType = outDataType[ColumbLoop];

            if(DataType == SQL_CHAR || DataType == SQL_VARCHAR || DataType == SQL_LONGVARCHAR)
            {
                SQLCHAR SQLBuffer[1024];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_CHAR, SQLBuffer, 1024, &DataLength))
                {
                    SQLBuffer[DataLength] = '\0';
                    if(DataLength == -1)
                    {
                        WriteCon("NULL");
                    }
                    else{
                        DataLength = CharTrim(SQLBuffer, DataLength);
                        WriteCon((char *)SQLBuffer);
                    }
                }
                else{
                    ErrorMessage(GetActiveWindow(),"DBGetData failed 1.\n");
                    return false;
                }
            }
            else if(DataType == SQL_TYPE_DATE || DataType == SQL_TYPE_TIME || DataType == SQL_TYPE_TIMESTAMP)
            {
                SQLCHAR SQLBuffer[255];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_CHAR, SQLBuffer, 255, &DataLength))
                {
                    SQLBuffer[DataLength] = '\0';

                    if(DataLength == -1)
                    {
                        WriteCon("NULL");
                    }
                    else{
                        DataLength = CharTrim(SQLBuffer, DataLength);
                        WriteCon((char *)SQLBuffer);
                    }
                }
                else{
                    ErrorMessage(GetActiveWindow(),"DBGetData failed 2.\n");
                    return false;
                }
            }
            else if(DataType == SQL_INTEGER || SQL_DECIMAL || SQL_NUMERIC || SQL_SMALLINT || SQL_REAL)
            {
                SQLINTEGER SQLBuffer = 0;
                char CharData[32];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_LONG, &SQLBuffer, 32, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteCon("NULL");
                    }
                    else{
                        sprintf(CharData, "%d", SQLBuffer);
                        DataLength = strlen(CharData);
                        WriteCon((char *)CharData);
                    }
                }
                else{
                    ErrorMessage(GetActiveWindow(),"DBGetData failed 3.\n");
                    return false;
                }
            }
            else if(DataType == SQL_DOUBLE || DataType == SQL_FLOAT)
            {
                SQLDOUBLE SQLBuffer = 0;
                char CharData[32];

                if(DBGetData(StatementHandle, ColumbLoop+1, SQL_C_DOUBLE, &SQLBuffer, 32, &DataLength))
                {
                    if(DataLength == -1)
                    {
                        WriteCon("NULL");
                    }
                    else{
                        sprintf(CharData, "%f", SQLBuffer);
                        DataLength = strlen(CharData);
                        WriteCon((char *)CharData);
                    }
                }
                else{
                    ErrorMessage(GetActiveWindow(),"DBGetData failed 4.\n");
                    return false;
                }
            }
            else{
                sprintf(StatusText, "Error in DumpSQLResultsToConsole :: Unknown SQL data type. Select Columb: %d, Type: %d\n", ColumbLoop, DataType);
                ErrorMessage(GetActiveWindow(), StatusText);
            }
            WriteCon("\t");
            ColumbLoop++;
        }
        WriteCon("\n");
    }

    sprintf(StatusText, "%d rows affected.\n", outRowCount, outColumnCount);
    WriteCon(StatusText);

    free(outDataType);
*/
    return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ConsoleDBConnect(void)
{
/*
	char Command[1025];
    int CommandLen = 0;

    bool DoDumpResults = false;

    SQLBasics MySQL;

    WriteCon("\nWhat database would you like to connect to?\n");
    WriteCon("1) Web Portal Index\n");
    WriteCon("2) Customer database\n");
    WriteCon("3) Cancel\n");
    WriteCon("Select: (1-4): ");

    CommandLen = GetConsoleInput(Command, 1024);
    if(strcmpi(Command, "1") == 0){
        if(!MySQL.DBConnect(gsSQLIndexDriver, gsSQLIndexServer, gsSQLIndexUserID, gsSQLIndexPassword, gsSQLIndexDatabase))
        {
            WriteCon("Error connecting to the database.\n");
            return false;
        }
        WriteCon("Connected.\n");
    }
    else if(strcmpi(Command, "2") == 0){
        while(true)
        {
            WriteCon("\nWhat database would you like to connect to?\n");
            CommandLen = GetConsoleInput(Command, 1024);

            if(!MySQL.DBConnect(gsSQLCustDriver, gsSQLCustServer, gsSQLCustUserID, gsSQLCustPassword, Command))
            {
                WriteCon("Error connecting to the database.\n");
                return false;
            }
            else{
                WriteCon("Connected.\n");
                break;
            }
        }
    }
    else{
        WriteCon("Cancelled.");
        return false;
    }

    HSTMT StatementHandle = NULL;

    WriteCon("\nQuery:> ");
    while(1)
    {
        CommandLen = GetConsoleInput(Command, 1024);
        if(CommandLen > 0)
        {
            if(strcmpi(Command, "help") == 0)
            {
                WriteCon(" Results:ON\t Turns row dump on.\n");
                WriteCon(" Results:OFF\t Turns row dump off.\n");
                WriteCon(" Disconnect\t Disconnects from the database.\n");
                WriteCon(" Cls\t\t Clears the screen\n");
            }
            else if(strcmpi(Command, "results:on") == 0)
            {
                DoDumpResults = true;
            }
            else if(strcmpi(Command, "cls") == 0)
            {
                system("cls");
            }
            else if(strcmpi(Command, "results:off") == 0)
            {
                DoDumpResults = false;
            }
            else if(strcmpi(Command, "disconnect") == 0)
            {
                MySQL.DBDisconnect();
                return true;
            }
            else{
                if(!MySQL.DBExecute(Command, &StatementHandle))
                {
                    WriteCon("Failed to execute statement.\n");
                }
                else{
                    if(DoDumpResults)
                        DumpSQLResultsToConsole(StatementHandle);
                    else DumpSQLStatsToConsole(StatementHandle);

                    DBCloseCursor(StatementHandle);
                }
            }
            WriteCon("\nQuery:> ");
        }
        else WriteCon("Query:> ");
        Sleep(1);
    }
*/
	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ProcessConsoleCoreCommand(char *Command)
{
/*
	char TempText[1024];

    if(strcmpi(Command, "help") == 0)
    {
        WriteCon(" Version\t Displays version info.\n");
        WriteCon(" Cls\t\t Clears the screen.\n");
        WriteCon(" Connections\t Displays conections info.\n");
        WriteCon(" DBConnect\t Connects to a database and execute commands.\n");
        WriteCon(" Exit\t\t Closes the console.\n");
        WriteCon(" Start\t\t Starts the server.\n");
        WriteCon(" Stop\t\t Stoppes the server.\n");
        WriteCon(" KillAll\t Kills all current connections.\n");
        WriteCon(" FlushLog\t Flushes the log file data to disk.\n");
        WriteCon(" readregistry\t Re-Reads all registry values.\n");
        WriteCon(" PauseTCP\t Pauses the TCPLoop thread.\n");
        WriteCon(" ResumeTCP\t Resumes the TCPLoop thread.\n");
        WriteCon(" Accept:ON\t Accepts incomming connections.\n");
        WriteCon(" Accept:OFF\t Rejects all incomming connections.\n");
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "cls") == 0)
    {
        system("cls");
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "accept:on") == 0)
    {
        gbAcceptConnections = true;
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "accept:off") == 0)
    {
        gbAcceptConnections = false;
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "pausetcp") == 0)
    {
        if(MyServer.SuspendTCPThread())
            WriteCon("TCPLoop paused.");
        else WriteCon("Error pausing TCPLoop.");
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "resumetcp") == 0)
    {
        if(MyServer.ResumeTCPThread())
            WriteCon("TCPLoop resumed.");
        else WriteCon("Error resuming TCPLoop.");
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "readregistry") == 0)
    {
        MyServer.SuspendTCPThread();
        if(GetRegistryValues())
            WriteCon("Registry vlaues re-read.");
        else WriteCon("Error reading registry values.");
        MyServer.ResumeTCPThread();
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "flushlog") == 0)
    {
        if(fflush(gfSessionLog) == 0)
            WriteCon("Log file flushed to disk.");
        else WriteCon("Error flushing log file.");
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "killall") == 0)
    {
        int Disconnects = 0;
        int LocalLoop = 0;
        while(LocalLoop < MAXCLIENTS)
        {
            if(MyServer.DisconnectClient(LocalLoop++))
                Disconnects++;
        }
        sprintf(TempText, "Disconnected %d clients.\n", Disconnects);
        WriteCon(TempText);
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "start") == 0)
    {
        if(StartServer())
            WriteCon("Server started.\n");
        else WriteCon("Failed to start the server.\n");
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "stop") == 0)
    {
        if(StopServer())
            WriteCon("Server stopped.\n");
        else WriteCon("Failed to stop the server.\n");
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "version") == 0)
    {
        sprintf(TempText, "%s - [Version: %s] (Built: %s at %s)\n", TitleCaption, FileVersion, __DATE__, __TIME__);
        WriteCon(TempText);
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "connections") == 0)
    {
        sprintf(TempText, "Class: %d, Global: %d, Total: %d\n", MyServer.Connections, glConnections, glTotalConnects);
        WriteCon(TempText);
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "dbconnect") == 0)
    {
        ConsoleDBConnect();
        return CONSOLE_CORE_RES_OK;
    }
    else if(strcmpi(Command, "exit") == 0)
    {
        return CONSOLE_CORE_RES_CLOSE;
    }
    else{
        sprintf(TempText, "Unknown command: '%s'.\n", Command);
        WriteCon(TempText);
        return CONSOLE_CORE_RES_UNKNOWN;
    }
*/
    return CONSOLE_CORE_RES_ERROR;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
